import requests
import asyncio
import customtkinter as ctk


general_color = '#2f3233'
light_color = '#373c40'
little_lighter = '#3f4142'
hover_text = '#565859'


class App(ctk.CTk):
    def __init__(self, title, size):
        super().__init__(fg_color = general_color)
        self.title(title)
        self.geometry(f'{size[0]}x{size[1]}')
        self.resizable(False, False)
        self.iconbitmap("1530369_weather_cloud_clouds_cloudy_icon.ico")
        #widgets
        Menu(self)
        
        
        #run
        self.mainloop()
        
class Menu(ctk.CTkFrame):
    def __init__(self, parent):
        super().__init__(parent, fg_color = general_color)
        
        self.rowconfigure((0,1,2,3,4,5), weight = 1, uniform = 'a')
        self.columnconfigure((0,1,2), weight = 1, uniform = 'a')
        APIKEY = '2d2d596dfd624590b48fdc2a119a8f21'
        
        
        
        input_box = ctk.CTkEntry(
            master = self, 
            corner_radius = 10, 
            fg_color = light_color, 
            placeholder_text_color = hover_text, 
            placeholder_text = 'Enter city here', 
            border_width = 2, 
            border_color = little_lighter, 
            text_color = '#edeff0', 
            font = ctk.CTkFont(family = 'Helvetica', 
                size = 24, 
                weight = 'bold'
                )
            )
        input_box.grid(row = 0, column = 2, rowspan = 2, pady = 20, padx = 5, sticky = 'nsew')
        
        sideframe = ctk.CTkScrollableFrame(master = self, fg_color = light_color)
        sideframe.grid(row = 0, column = 0, rowspan = 5, columnspan = 2, padx = 10, pady = 10, sticky = 'nsew')
        
        maintext = ctk.CTkLabel(master = self, text = 'Weather', justify = 'left', anchor = 'w', text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 36, weight = 'bold'))
        maintext.grid(row = 5, column = 0, rowspan = 1, columnspan = 2, padx = 20, pady = 5, sticky = 'nsew')

        global city_name
        def city_name():
            for widget in sideframe.winfo_children():
                widget.destroy()
            city_name = input_box.get()
            city_name_2 = str(city_name)
            if " " in city_name_2:
                city_name_2.replace(" ","_")
            if city_name_2[0].isupper():
                pass
            else:
                city_name_2[0].upper()
            global weather
            weather = requests.get('https://api.weatherbit.io/v2.0/current?units=I&&city="'+city_name_2+'"&country=US&key='+APIKEY+'')
            weather = weather.json()
            print(weather)
            
            
        
            weather_data = weather['data']
            
            for city_data in weather_data:
                city_label = "City name: " + str(city_data['city_name'])
                city_temp = "Temperature: " + str(city_data['temp']) + "° F"
                city_time = "Local time/Date: " + str(city_data['datetime'])
                city_sunrise = "City Sunrise: " + str(city_data['sunrise']) + " U.T.C"
                city_sunset = "City Sunset: " + str(city_data['sunset']) + " U.T.C"
                city_windspeed = "Wind Speed: " + str(city_data['wind_spd']) + " mph"
                city_precipitation = "Precipitation: " + str(city_data['precip']) + "%"
                city_uv = "UV index: " + str(city_data['uv']) + "%"
                city_aqi = "Air Quality Index: " + str(city_data['aqi']) + "%"
            city_name_label = ctk.CTkLabel(master = sideframe, text = city_label, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_name_label.pack(pady = 5, padx = 5)
            city_label_temp = ctk.CTkLabel(master = sideframe, text = city_temp, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_temp.pack(pady = 5, padx = 5)
            city_label_time = ctk.CTkLabel(master = sideframe, text = city_time, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_time.pack(pady = 5, padx = 5)
            city_label_sunrise = ctk.CTkLabel(master = sideframe, text = city_sunrise, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_sunrise.pack(pady = 5, padx = 5)
            city_label_sunset = ctk.CTkLabel(master = sideframe, text = city_sunset, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_sunset.pack(pady = 5, padx = 5)
            city_label_windspeed = ctk.CTkLabel(master = sideframe, text = city_windspeed, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_windspeed.pack(pady = 5, padx = 5)
            city_label_precipitation = ctk.CTkLabel(master = sideframe, text = city_precipitation, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_precipitation.pack(pady = 5, padx = 5)
            city_label_uv = ctk.CTkLabel(master = sideframe, text = city_uv, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_uv.pack(pady = 5, padx = 5)
            city_label_aqi = ctk.CTkLabel(master = sideframe, text = city_aqi, text_color = '#edeff0', font = ctk.CTkFont(family = 'Helvetica', size = 20, weight = 'bold'))
            city_label_aqi.pack(pady = 5, padx = 5)
        
        
        enter_button = ctk.CTkButton(master = self, 
            text = 'Get Weather', 
            text_color = '#edeff0', 
            fg_color = light_color, 
            border_width = 2, 
            border_color = little_lighter, 
            hover_color = little_lighter, 
            corner_radius = 20, 
            font = ctk.CTkFont(family = 'Helvetica', size = 24, weight = 'bold'), 
            command = city_name)
        enter_button.grid(row = 2, column = 2, sticky = 'nsew', padx = 10)   
        
        
        
        self.pack(fill = 'both', expand = True, ipadx = 25, ipady = 5)
        
       
        
App('Weather', (700,400))
        


